<?php
/*
* Title                   : Thumbnail Scroller (WP NextGEN Gallery Template)
* Version                 : 1.0
* File                    : gallery-dop-thumbnail-scroller.js
* File Version            : 1.0
* Created / Last Modified : 30 May 2012
* Author                  : Marius-Cristian Donea
* Copyright               : © 2012 Marius-Cristian Donea
* Website                 : http://www.mariuscristiandonea.com
* Description             : NextGen Gallery Template.
*/

    if (!defined ('ABSPATH')) die ('No direct access allowed'); 
    
    // Register Styles.
    wp_register_style('DOPNGTS_JScrollPaneStyle', get_template_directory_uri().'/nggallery/libraries/gui/css/jquery.jscrollpane.css');
    wp_register_style('DOPNGTS_NextGENThumbnailScrollerStyle', get_template_directory_uri().'/nggallery/assets/gui/css/jquery.dop.NextGENThumbnailScroller.css');
    // Register JavaScript.
    wp_register_script('jqueryUI', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.11/jquery-ui.min.js', array('jquery'));
    wp_register_script('DOPNGTS_MouseWheelJS', get_template_directory_uri().'/nggallery/libraries/js/jquery.mousewheel.js', array('jquery'));
    wp_register_script('DOPNGTS_JScrollPaneJS', get_template_directory_uri().'/nggallery/libraries/js/jquery.jscrollpane.min.js', array('jquery'));
    wp_register_script('DOPNGTS_NextGENThumbnailScrollerJS', get_template_directory_uri().'/nggallery/assets/js/jquery.dop.NextGENThumbnailScroller.js', array('jquery'));
    wp_register_script('DOPNGTS_DOPNGTSJS', get_template_directory_uri().'/nggallery/assets/js/dopngts.js', array('jquery'));

    // Enqueue Styles.
    wp_enqueue_style('DOPNGTS_JScrollPaneStyle');
    wp_enqueue_style('DOPNGTS_NextGENThumbnailScrollerStyle');
   
    // Enqueue JavaScript.
    if (!wp_script_is('jquery', 'queue')){
        wp_enqueue_script('jquery');
    }
    wp_enqueue_script('jqueryUI');
    wp_enqueue_script('DOPNGTS_MouseWheelJS');
    wp_enqueue_script('DOPNGTS_JScrollPaneJS');
    wp_enqueue_script('DOPNGTS_NextGENThumbnailScrollerJS');
    wp_enqueue_script('DOPNGTS_DOPNGTSJS');
        
    if (!empty ($gallery)){                
?>
<script type="text/JavaScript">
<!--
    var DOPNextGENThumbnailScrollerSettings<?php echo $gallery->ID;?> = {
        "Width": 901, // Width (value in pixels). Default value: 900. Set the width of the scroller.
        "Height": 128, // Height (value in pixels). Default value: 128. Set the height of the scroller.")
        "BgColor": "ffffff", // Background Color (color hex code). Default value: ffffff. Set scroller background color.
        "BgAlpha": 0, // Background Alpha (value from 0 to 100). Default value: 100. Set scroller alpha.
        "BgBorderSize": 0, // Background Border Size (value in pixels). Default value: 1. Set the size of the scroller border.
        "BgBorderColor": "e0e0e0", // Background Border Color (color hex code). Default value: e0e0e0. Set the color of the scroller border.
        "ThumbnailsOrder": "random", // Thumbnails Order (normal, random). Default value: normal. Set thumbnails order.
        "ResponsiveEnabled": "true", // Responsive Enabled (true, false). Default value: true. Enable responsive layout.
        "ThumbnailsPosition": "horizontal", // Thumbnails Position (horizontal, vertical). Default value: horizontal. Set the position of the thumbnails.
        "ThumbnailsBgColor": "ffffff", // Thumbnails Background Color (color hex code). Default value: ffffff. Set the color for the thumbnails background.
        "ThumbnailsBgAlpha": 100, // Thumbnails Background Alpha (value from 0 to 100). Default value: 0. Set the transparancy for the thumbnails background.
        "ThumbnailsBorderSize": 1, // Thumbnails Background Border Size (value in pixels). Default value: 0. Set the size of the thumbnails border.
        "ThumbnailsBorderColor": "e0e0e0", // Thumbnails Background Border Color (color hex code). Default value: e0e0e0. Set the color of the thumbnails border.
        "ThumbnailsSpacing": 10, // Thumbnails Spacing (value in pixels). Default value: 10. Set the space between thumbnails.
        "ThumbnailsMarginTop": 0, // Thumbnails Margin Top (value in pixels). Default value: 10. Set the top margin for the thumbnails.
        "ThumbnailsMarginRight": 0, // Thumbnails Margin Right (value in pixels). Default value: 0. Set the right margin for the thumbnails.
        "ThumbnailsMarginBottom": 0, // Thumbnails Margin Bottom (value in pixels). Default value: 10. Set the bottom margin for the thumbnails.
        "ThumbnailsMarginLeft": 0, // Thumbnails Margin Left (value in pixels). Default value: 0. Set the left margin for the thumbnails.
        "ThumbnailsPaddingTop": 10, // Thumbnails Padding Top (value in pixels). Default value: 0. Set the top padding for the thumbnails.
        "ThumbnailsPaddingRight": 10, // Thumbnails Padding Right (value in pixels). Default value: 0. Set the right padding for the thumbnails.
        "ThumbnailsPaddingBottom": 10, // Thumbnails Padding Bottom (value in pixels). Default value: 0. Set the bottom padding for the thumbnails.
        "ThumbnailsPaddingLeft": 10, // Thumbnails Padding Left (value in pixels). Default value: 0. Set the left padding for the thumbnails.
        "ThumbnailsInfo": "tooltip", // Info Thumbnails Display (none, tooltip, label). Default value: label. Display a small info text on the thumbnails, a tooltip or a label.
        "ThumbnailsNavigationEasing": "linear", // Thumbnails Navigation Easing (linear, swing, easeInQuad, easeOutQuad, easeInOutQuad, easeInCubic, easeOutCubic, easeInOutCubic, easeInQuart, easeOutQuart, easeInOutQuart, easeInQuint, easeOutQuint, easeInOutQuint, easeInSine, easeOutSine, easeInOutSine, easeInExpo, easeOutExpo, easeInOutExpo, easeInCirc, easeOutCirc, easeInOutCirc, easeInElastic, easeOutElastic, easeInOutElastic, easeInBack, easeOutBack, easeInOutBack, easeInBounce, easeOutBounce, easeInOutBounce). Default value: linear. Set thumbnails navigation easing.
        "ThumbnailsNavigationLoop": "false", // Enable Thumbnails Loop (true, false). Default value: false. Enable thumbnails loop ... scroll will be disabled.
        "ThumbnailsNavigationMouseEnabled": "true", // Enable Thumbnails Mouse Navigation (true, false). Default value: false. Enable thumbnails mouse navigation.
        "ThumbnailsNavigationScrollEnabled": "false", // Enable Thumbnails Scroll Navigation (true, false). Default value: false. Enable thumbnails scroll navigation.
        "ThumbnailsScrollPosition": "bottom/right", // Thumbnails Scroll Position (bottom/right, top/left). Default value: bottom/right. Set thumbnails scroll position.
        "ThumbnailsScrollSize": 5, // Thumbnails Scroll Size (value in pixels). Default value: 5. Set the scroll size color.
        "ThumbnailsScrollScrubColor": "808080", // Thumbnails Scroll Scrub Color (color hex code). Default value: 808080. Set the scroll scrub color.
        "ThumbnailsScrollBarColor": "e0e0e0", // Thumbnails Scroll Bar Color (color hex code). Default value: e0e0e0. Set the scroll bar color.
        "ThumbnailsNavigationArrowsEnabled": "true", // Enable Thumbnails Arrows Navigation (true, false). Default value: true. Enable thumbnails arrows navigation.
        "ThumbnailsNavigationArrowsNoItemsSlide": 1, // Thumbnails Navigation Arrows Number Items Slide (number of thumbnails). Default value: 1. The number of thumbnails that will slide when you click the arrows.
        "ThumbnailsNavigationArrowsSpeed": 600, // Thumbnails Navigation Arrows Speed (time in miliseconds). Default value: 600. The time the thumbnails will slide after you click the arrows.
        "ThumbnailsNavigationPrev": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsPrev4.png", // Thumbnails Navigation Previous Button Image (path to image). Upload the image for thumbnails navigation's previous button.
        "ThumbnailsNavigationPrevHover": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsPrevHover4.png", // Thumbnails Navigation Previous Button Hover Image (path to image). Upload the image for thumbnails navigation's previous hover button.
        "ThumbnailsNavigationPrevDisabled": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsPrevDisabled4.png", // Thumbnails Navigation Previous Button Disabled Image (path to image). Upload the image for thumbnails navigation's previous disabled button.
        "ThumbnailsNavigationNext": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsNext4.png", // Thumbnails Navigation Next Button Image (path to image). Upload the image for thumbnails navigation's next button.
        "ThumbnailsNavigationNextHover": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsNextHover4.png", // Thumbnails Navigation Next Button Hover Image (path to image). Upload the image for thumbnails navigation's next hover button.
        "ThumbnailsNavigationNextDisabled": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailsNextDisabled4.png", // Thumbnails Navigation Next Button Disabled Image (path to image). Upload the image for thumbnails navigation's next disabled button.
        "ThumbnailLoader": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/ThumbnailLoader.gif", // Thumbnail Loader (path to image). Set the loader for the thumbnails.
        "ThumbnailWidth": 100, // Thumbnail Width (the size in pixels). Default value: 100. Set the width of a thumbnail.
        "ThumbnailHeight": 100, // Thumbnail Height (the size in pixels). Default value: 100. Set the height of a thumbnail.
        "ThumbnailAlpha": 100, // Thumbnail Alpha (value from 0 to 100). Default value: 100. Set the transparancy of a thumbnail.
        "ThumbnailAlphaHover": 100, // Thumbnail Alpha Hover (value from 0 to 100). Default value: 100. Set the transparancy of a thumbnail when hover.
        "ThumbnailBgColor": "f1f1f1", // Thumbnail Background Color (color hex code). Default value: f1f1f1. Set the color of a thumbnail's background.
        "ThumbnailBgColorHover": "f1f1f1", // Thumbnail Background Color Hover (color hex code). Default value: f1f1f1. Set the color of a thumbnail's background when hover.
        "ThumbnailBorderSize": 1, // Thumbnail Border Size (value in pixels). Default value: 1. Set the size of a thumbnail's border.
        "ThumbnailBorderColor": "d0d0d0", // Thumbnail Border Color (color hex code). Default value: d0d0d0. Set the color of a thumbnail's border.
        "ThumbnailBorderColorHover": "303030", // Thumbnail Border Color Hover (color hex code). Default value: 303030. Set the color of a thumbnail's border when hover.
        "ThumbnailPaddingTop": 2, // Thumbnail Padding Top (value in pixels). Default value: 2. Set top padding value of a thumbnail.
        "ThumbnailPaddingRight": 2, // Thumbnail Padding Right (value in pixels). Default value: 2. Set right padding value of a thumbnail.
        "ThumbnailPaddingBottom": 2, // Thumbnail Padding Bottom (value in pixels). Default value: 2. Set bottom padding value of a thumbnail.
        "ThumbnailPaddingLeft": 2, // Thumbnail Padding Left (value in pixels). Default value: 2. Set left padding value of a thumbnail.
        "LightboxEnabled": "true", // Enable Lightbox (true, false). Default value: true. Enable the lightbox.
        "LightboxDisplayTime": 600, // Lightbox Display Time (time in miliseconds). Default value: 600. The time the lightbox will be displayed.
        "LightboxWindowColor": "ffffff", // Lightbox Window Color (color hex code). Default value: ffffff. Set the color for the lightbox window.
        "LightboxWindowAlpha": 80, // Lightbox Window Alpha (value from 0 to 100). Default value: 80. Set the transparancy for the lightbox window.
        "LightboxLoader": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxLoader.gif", // Lightbox Loader (path to image). Set the loader for the lightbox image.
        "LightboxBgColor": "ffffff", // Lightbox Background Color (color hex code). Default value: ffffff. Set the color for the lightbox background.
        "LightboxBgAlpha": 100, // Lightbox Background Alpha (value from 0 to 100). Default value: 100. Set the transparancy for the lightbox background.
        "LightboxBorderSize": 1, // Lightbox Border Size (value in pixels). Default value: 1. Set the size of a lightbox's border.
        "LightboxBorderColor": "e0e0e0", // Lightbox Border Color (color hex code). Default value: e0e0e0. Set the color of a lightbox's border.
        "LightboxCaptionTextColor": "999999", // Lightbox Caption Text Color (color hex code). Default value: 999999. Set the color for the lightbox caption.
        "LightboxMarginTop": 30, // Lightbox Margin Top (value in pixels). Default value: 30. Set top margin value for the lightbox.
        "LightboxMarginRight": 30, // Lightbox Margin Right (value in pixels). Default value: 30. Set right margin value for the lightbox.
        "LightboxMarginBottom": 30, // Lightbox Margin Bottom (value in pixels). Default value: 30. Set bottom margin value for the lightbox.
        "LightboxMarginLeft": 30, // Lightbox Margin Left (value in pixels). Default value: 30. Set top left value for the lightbox.
        "LightboxPaddingTop": 10, // Lightbox Padding Top (value in pixels). Default value: 10. Set top padding value for the lightbox.
        "LightboxPaddingRight": 10, // Lightbox Padding Right (value in pixels). Default value: 10. Set right padding value for the lightbox.
        "LightboxPaddingBottom": 10, // Lightbox Padding Bottom (value in pixels). Default value: 10. Set bottom padding value for the lightbox.
        "LightboxPaddingLeft": 10, // Lightbox Padding Left (value in pixels). Default value: 10. Set left padding value for the lightbox.
        "LightboxNavigationPrev": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxPrev.png", // Lightbox Navigation Previous Button Image (path to image). Upload the image for lightbox navigation's previous button.
        "LightboxNavigationPrevHover": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxPrevHover.png", // Lightbox Navigation Previous Button Hover Image (path to image). Upload the image for lightbox navigation's previous hover button.
        "LightboxNavigationNext": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxNext.png", // Lightbox Navigation Next Button Image (path to image). Upload the image for lightbox navigation's next button.
        "LightboxNavigationNextHover": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxNextHover.png", // Lightbox Navigation Next Button Hover Image (path to image). Upload the image for lightbox navigation's next hover button.
        "LightboxNavigationClose": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxClose.png", // Lightbox Navigation Close Button Image (path to image). Upload the image for lightbox navigation's close button.
        "LightboxNavigationCloseHover": "<?php echo get_template_directory_uri()?>/nggallery/assets/gui/images/LightboxCloseHover.png", // Lightbox Navigation Close Button Hover Image (path to image). Upload the image for lightbox navigation's close hover button.
        "LightboxNavigationInfoBgColor": "ffffff", // Lightbox Navigation Info Background Color (color hex code). Default value: ffffff. Set the color for the lightbox info background.
        "LightboxNavigationInfoTextColor": "c0c0c0", // Lightbox Navigation Info Text Color (color hex code). Default value: c0c0c0. Set the color for the lightbox info text.
        "LightboxNavigationDisplayTime": 600, // Lightbox Navigation Display Time (time in miliseconds). Default value: 600. The time the lightbox navigation will be displayed.
        "LightboxNavigationTouchDeviceSwipeEnabled": "true", // Swipe Lightbox Navigation Enabled (true, false). Default value: true. Enable swipe lightbox navigation on touch devices.
        "TooltipBgColor": "ffffff", // Tooltip Background Color (color hex code). Default value: ffffff. Set tooltip background color.
        "TooltipStrokeColor": "000000", // Tooltip Stroke Color (color hex code). Default value: 000000. Set tooltip stroke color.
        "TooltipTextColor": "000000", // Tooltip Text Color (color hex code). Default value: 000000. Set tooltip text color.
        "LabelPosition": "bottom", // Label Position (bottom, top). Default value: bottom. Set label position.
        "LabelBgColor": "000000", // Label Position (bottom, top). Default value: bottom. Set label position.
        "LabelBgAlpha": 80, // Label Background Alpha (value from 0 to 100). Default value: 80. Set label background transparancy.
        "LabelTextColor": "ffffff", // Label Text Color (color hex code). Default value: ffffff. Set label text color.
        "SlideshowEnabled": "false", // Slideshow Enabled (true, false). Default value: false. Enable or disable the slideshow.
        "SlideshowTime": 5000, // Slideshow Time (time in miliseconds). Default: 5000. How much time a thumbnail stays until it passes to the next one.
        "SlideshowLoop": "false" // Slideshow Loop (true, false). Default: false. Set it to true if you don't want the slideshow to stop when it reaches the last thumbnail.
    },        
    DOPNextGENThumbnailScrollerContent<?php echo $gallery->ID; ?> = [    
<?php
        $i = 0;
    
        foreach ($images as $image):
            $i++;
                
            echo '{"Image": "'.$image->imageURL.'",'.
                  '"Thumb": "'.$image->thumbURL.'",'.
                  '"Title": "'.($image->alttext == ' ' ? '':$image->alttext).'",'.
                  '"Caption": \''.($image->description == ' ' ? '':preg_replace('`[\r\n]`', "<br />", html_entity_decode(stripslashes($image->description)))).'\','.
                  '"Media": \''.preg_replace('`[\r\n]`', "", stripslashes($image->ngg_custom_fields['Media'])).'\','.
                  '"LightboxMedia": \''.preg_replace('`[\r\n]`', "", stripslashes($image->ngg_custom_fields['LightboxMedia'])).'\','.
                  '"Link": \''.stripslashes($image->ngg_custom_fields['Link']).'\','.
                  '"Target": \''.stripslashes($image->ngg_custom_fields['LinkTarget']).'\'}';
            if ($i != count($images)){        
                echo ','."\n";
            }            
        endforeach;
?>           
    ];      
//-->
</script>
<div class="DOPNextGENThumbnailScroller" id="DOPNextGENThumbnailScroller<?php echo $gallery->ID; ?>"></div>  
<?php
    }
?>