/**
 * Equal Heights Plugin
 * Equalize the heights of elements. Great for columns or any elements
 * that need to be the same size (floats, etc).
 *
 * Version 1.0
 * Updated 12/10/2008
 * Modified for Weaver II - Bruce Wampler - 12/21/11
 *
 * Copyright (c) 2008 Rob Glazebrook (cssnewbie.com)
 *
 */

(function($) {
	$.fn.equalHeights = function(minHeight, maxHeight) {
		tallest = (minHeight) ? minHeight : 0;
		this.each(function() {
			if($(this).height() > tallest) {
				tallest = $(this).height();
			}
		});
		if((maxHeight) && tallest > maxHeight) tallest = maxHeight;
		return this.each(function() {
			$(this).height(tallest).css("overflow","visible");
		});
	}
})(jQuery);

jQuery(window).load(function() { jQuery(".equal_height").equalHeights(); });

